/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.util.i18n;

import com.google.common.collect.ImmutableSet;
import cz.insophy.inplan.util.io.TokenResolver;
import java.util.ResourceBundle;

public class ResourceBundleTokenResolver
implements TokenResolver {
    private final ResourceBundle bundle;

    public ResourceBundleTokenResolver(ResourceBundle bundle) {
        this.bundle = bundle;
    }

    @Override
    public String resolveToken(String tokenName) {
        if (this.bundle == null) {
            return null;
        }
        if (this.bundle.containsKey(tokenName)) {
            return this.bundle.getString(tokenName);
        }
        return null;
    }

    @Override
    public boolean isTokenResolved(String tokenName) {
        return this.bundle != null && this.bundle.containsKey(tokenName);
    }

    @Override
    public ImmutableSet<String> getAllKeys() {
        if (this.bundle == null) {
            return ImmutableSet.of();
        }
        return ImmutableSet.copyOf(this.bundle.keySet());
    }
}

